/*---------------------------------------------
Template name: CryptoCloud
Version: 1.4
Author: ThemeLooks
Author url: http://themelooks.com

NOTE:
------
Please DO NOT EDIT THIS JS, you may need to use "custom.js" file for writing your custom js.
We may release future updates so it will overwrite this file. it's better and safer to use "custom.js".

[Table of Content]

01: Sticky header
02: Back to top button
03: Top padding for menu
04: Preloader

----------------------------------------------*/


(function($) {
    "use strict";
    $(function(){

        
        /* 01: Sticky header
        ==============================================*/

        var $headerContainer = $('.header-container');

        $(window).on('scroll', function(){
            if($(window).scrollTop() >= 15){
                $headerContainer.addClass('sticking');
            } 
            else {
                $headerContainer.removeClass('sticking');
            }
        }).scroll();
        
        /* 02: Back to top button
        ==============================================*/

        var $backToTopBtn = $('.back-to-top');

        if ($backToTopBtn.length) {
            var scrollTrigger = 400, // px
            backToTop = function () {
                var scrollTop = $(window).scrollTop();
                if (scrollTop > scrollTrigger) {
                    $backToTopBtn.addClass('show');
                } else {
                    $backToTopBtn.removeClass('show');
                }
            };

            backToTop();

            $(window).on('scroll', function () {
                backToTop();
            });

            $backToTopBtn.on('click', function (e) {
                e.preventDefault();
                $('html,body').animate({
                    scrollTop: 0
                }, 700);
            });
        }

        
        /* 3: Top padding for menu
        ==============================================*/

        var $header = $('header.header');

        $header.next().addClass('top-spacing');
    });
    

    /* 04: Preloader
    ==============================================*/

    $("#fakeLoader").fakeLoader({
        timeToHide: 1000,
        zIndex: 99999,
        spinner: "spinner6"
    });

})(jQuery);
